﻿using NixUniversalSDK;
using Windows.ApplicationModel.Resources;

namespace NixExampleWinUI.Helpers;

public static class LicenseManagerHelper
{
    public static IEnumerable<SimpleInfoItem> GetLicenseInfoList()
    {
        // String resources
        ResourceLoader loader = ResourceLoader.GetForViewIndependentUse();

        // Create and fill the list
        var list = new List<SimpleInfoItem>();

        // License state
        list.Add(new SimpleInfoItem(
            type: SimpleInfoItem.ListType.LicenseInfo,
            title: loader.GetString("TitleLicenseState"),
            subtitle: LicenseManager.State.ToString()));

        switch (LicenseManager.State)
        {
            case LicenseManagerState.Active:
            case LicenseManagerState.ErrorLicenseExpired:
                // Valid states to list further license details
                {
                    // UUID
                    list.Add(new SimpleInfoItem(
                        type: SimpleInfoItem.ListType.LicenseInfo,
                        title: loader.GetString("TitleUuid"),
                        subtitle: LicenseManager.Uuid));

                    // Expiry
                    list.Add(new SimpleInfoItem(
                        type: SimpleInfoItem.ListType.LicenseInfo,
                        title: loader.GetString("TitleExpiry"),
                        subtitle: LicenseManager.Expiry.ToString()));

                    // Allocations
                    list.Add(new SimpleInfoItem(
                        type: SimpleInfoItem.ListType.LicenseInfo,
                        title: loader.GetString("TitleAllocations"),
                        subtitle: string.Join(", ", LicenseManager.Allocations)));

                    // Allowed devices
                    list.Add(new SimpleInfoItem(
                        type: SimpleInfoItem.ListType.LicenseInfo,
                        title: loader.GetString("TitleDeviceTypes"),
                        subtitle: string.Join(", ", LicenseManager.AllowedDeviceTypes)));

                    // Features
                    list.Add(new SimpleInfoItem(
                        type: SimpleInfoItem.ListType.LicenseInfo,
                        title: loader.GetString("TitleFeatures"),
                        subtitle: string.Join(", ", LicenseManager.Features)));
                }
                break;
            case LicenseManagerState.Inactive:
            case LicenseManagerState.ErrorLicenseBadSignature:
            case LicenseManagerState.ErrorLicenseInvalidOptions:
            case LicenseManagerState.ErrorInternal:
            default:
                // Nothing else to report from the LicenseManager
                break;
        }

        // SDK version
        list.Add(new SimpleInfoItem(
            type: SimpleInfoItem.ListType.LicenseInfo,
            title: loader.GetString("TitleLibraryVersion"),
            subtitle: LicenseManager.LibraryVersion));

        // Return the list
        return list;
    }
}