﻿using Microsoft.UI.Xaml.Data;
using NixUniversalSDK;

namespace NixExampleWinUI.Helpers;

public class ScanModeToIntConverter : IValueConverter
{
    public object Convert(object value, Type targetType, object parameter, string language)
    {
        if (value is not ScanMode)
        {
            throw new InvalidOperationException("The target must be a ScanMode enum");
        }

        // ScanMode is internally defined as byte
        // Return -1 for NA
        return (ScanMode)value switch
        {
            ScanMode.M0 or ScanMode.M1 or ScanMode.M2 => (byte)value,
            _ => -1
        };
    }

    public object ConvertBack(object value, Type targetType, object parameter, string language)
    {
        if (value is not int)
        {
            throw new InvalidOperationException("The target must be a boolean");
        }

        var intValue = (int)value;

        if (intValue < 0)
        {
            return ScanMode.NA;
        } 
        else
        {
            return ScanModeExtensions.GetScanMode(System.Convert.ToByte(intValue));            
        }
    }
}