using Microsoft.UI.Xaml.Controls;
using NixExampleWinUI.ViewModels;

// To learn more about WinUI, the WinUI project structure,
// and more about our project templates, see: http://aka.ms/winui-project-info.

namespace NixExampleWinUI.Views
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class ActivateLicenseContentDialog : ContentDialog
    {
        bool CloseOnClick = true;
        
        public ActivateLicenseViewModel ViewModel { get; }
        
        public ActivateLicenseContentDialog()
        {
            ViewModel = App.GetService<ActivateLicenseViewModel>();
            this.InitializeComponent();
        }

        private void ContentDialog_PrimaryButtonClick(ContentDialog sender, ContentDialogButtonClickEventArgs args)
        {
            CloseOnClick = false;

            // Run the activate command and store the returned state
            ViewModel.LastState = NixUniversalSDK.LicenseManager.Activate(
                options: ViewModel.Options, 
                signature: ViewModel.Signature);
        }

        private void ContentDialog_CloseButtonClick(ContentDialog sender, ContentDialogButtonClickEventArgs args)
        {
            CloseOnClick = true;
        }

        private void ContentDialog_Closing(ContentDialog sender, ContentDialogClosingEventArgs args)
        {
            args.Cancel = !CloseOnClick;
        }
    }
}
