using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Controls;
using NixExampleWinUI.ViewModels;
using NixUniversalSDK;

// To learn more about WinUI, the WinUI project structure,
// and more about our project templates, see: http://aka.ms/winui-project-info.

namespace NixExampleWinUI.Views;

/// <summary>
/// Custom view to plot the <see cref="ISpectralData"/> for a <see cref="IMeasurementData"/> instance.
/// </summary>
public sealed partial class SpectralPlot : UserControl
{
    public SpectralPlotViewModel ViewModel
    {
        get;
    }
    
    public IMeasurementData? MeasurementData
    {
        get => ViewModel.MeasurementData;
        set => ViewModel.MeasurementData = value;
    }

    public SpectralPlot()
    {
        ViewModel = App.GetService<SpectralPlotViewModel>();
        this.InitializeComponent();
    }

    private void ZoomOutButton_Click(object sender, RoutedEventArgs e) => ViewModel.ResetPlotZoom();
}
