﻿using Microsoft.UI.Xaml.Media;
using Microsoft.UI.Xaml.Data;
using Windows.UI;
using Microsoft.UI;

namespace NixExampleWinUI.Helpers;

public class ColorToSolidColorBrushConverter : IValueConverter
{
    public object Convert(object value, Type targetType, object parameter, string language)
    {
        var safeColor = Colors.Black;
        if (value is Color colorValue)
        {
            safeColor = colorValue;
        }
        return new SolidColorBrush(safeColor);
    }

    public object ConvertBack(object value, Type targetType, object parameter, string language)
    {
        var safeColor = Colors.Black;
        if (value is SolidColorBrush brushValue)
        {
            safeColor = brushValue.Color;
        }
        return safeColor;
    }
}