﻿using NixExampleWinUI.Views;
using NixUniversalSDK;
using Windows.ApplicationModel.Resources;

namespace NixExampleWinUI.Helpers;

public static class MeasurementHelper
{
    /// <summary>
    /// Provides a list of <see cref="SimpleInfoItem"/> for an <see cref="IMeasurementData"/> instance, useful for populating <see cref="InfoListContentDialog"/>.
    /// </summary>
    public static IEnumerable<SimpleInfoItem> GetMeasurementInfoList(this IMeasurementData? data)
    {
        // String resources
        var loader = ResourceLoader.GetForViewIndependentUse();

        // Temperature formatter
        var temperatureFormat = (data?.TReal == true) ?
            loader.GetString("TemperatureFormatCelsius") :
            loader.GetString("TemperatureFormatRaw");

        // Create and fill the list
        var list = new List<SimpleInfoItem>();

        // Device Name
        if (data?.DeviceType.GetFullName() is string deviceName)
        {
            list.Add(new SimpleInfoItem(
                type: SimpleInfoItem.ListType.ScanInfo,
                title: loader.GetString("TitleDeviceName"),
                subtitle: deviceName));
        }

        // Reference Temperature        
        if (data?.TRef is float tRef)
        {
            list.Add(new SimpleInfoItem(
                type: SimpleInfoItem.ListType.ScanInfo,
                title: loader.GetString("TitleReferenceTemperature"),
                subtitle: string.Format(temperatureFormat, tRef)));
        }

        // Scan Temperature
        if (data?.TScan is float tScan)
        {
            list.Add(new SimpleInfoItem(
                type: SimpleInfoItem.ListType.ScanInfo,
                title: loader.GetString("TitleScanTemperature"),
                subtitle: string.Format(temperatureFormat, tScan)));
        }

        // Temperature Compensation
        if (data?.TCompEnabled is bool tCompEnabled)
        {
            var label = tCompEnabled ? loader.GetString("ValueEnabled") : loader.GetString("ValueDisabled");
            list.Add(new SimpleInfoItem(
                type: SimpleInfoItem.ListType.ScanInfo,
                title: loader.GetString("TitleTemperatureCompensation"),
                subtitle: label));
        }

        // Tile Normalization
        if (data?.TileEnabled is bool tileEnabled)
        {
            var label = tileEnabled ? loader.GetString("ValueEnabled") : loader.GetString("ValueDisabled");
            list.Add(new SimpleInfoItem(
                type: SimpleInfoItem.ListType.ScanInfo,
                title: loader.GetString("TitleTileNormalization"),
                subtitle: label));
        }

        return list;
    }
}
