﻿namespace NixExampleWinUI.Helpers;

public class SimpleInfoItem
{
    public enum ListType : int
    {
        DeviceOptions = 0,
        ReferenceWhiteOptions = 1,
        ScanInfo = 2,
        DeviceInfo = 3,
        LicenseInfo = 4,
        Undefined = -1
    }

    public SimpleInfoItem(
        ListType type,
        string? title,
        string? subtitle = null,
        bool? isChecked = false,
        bool isEnabled = false,
        int? id = null)
    {
        Type = type;
        Title = title;
        Subtitle = subtitle;
        IsChecked = isChecked;
        IsEnabled = isEnabled;
        Id = id;
    }

    public readonly ListType Type;
    public readonly string? Title;
    public readonly string? Subtitle;
    public readonly bool? IsChecked;
    public readonly bool? IsEnabled;
    public readonly int? Id;
}