using System.Diagnostics;
using CommunityToolkit.Mvvm.ComponentModel;
using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Controls;
using Microsoft.UI.Xaml.Data;
using NixExampleWinUI.Helpers;

// To learn more about WinUI, the WinUI project structure,
// and more about our project templates, see: http://aka.ms/winui-project-info.

namespace NixExampleWinUI.Views;

/// <summary>
/// Custom dialog containing a <see cref="ListView"/> of <see cref="SimpleInfoItem"/> objects. Used in the example to show additional scan details and additional device details.
/// </summary>
public sealed partial class InfoListContentDialog : ContentDialog
{    
    private IEnumerable<SimpleInfoItem> _Items = new List<SimpleInfoItem>();
    public IEnumerable<SimpleInfoItem> Items
    {
        get => _Items; 
        private set => _Items = value;
    }

    public InfoListContentDialog(IEnumerable<SimpleInfoItem>? items = null)
    {
        this.InitializeComponent();
        
        if (items is not null)
        {
            // Save reference to items
            Items = items;

            // Set `ItemsSource` on the ListView to the items.
            // Doing this in code behind instead of Xaml to allow overriding of
            // ItemsSource when using this component
            var binding = new Binding()
            {
                Source = this,
                Path = new PropertyPath(nameof(Items)),
                Mode = BindingMode.OneTime
            };
            InfoListView.SetBinding(ListView.ItemsSourceProperty, binding);
        }
    }
}
