﻿using Microsoft.UI.Xaml.Data;

namespace NixExampleWinUI.Helpers;

public class InverseBooleanConverter : IValueConverter
{
    public object Convert(object value, Type targetType, object parameter, string language)
    {
        if (value is not bool)
        {
            throw new InvalidOperationException("The target must be a boolean");
        }
        return !(bool)value;
    }

    public object ConvertBack(object value, Type targetType, object parameter, string language)
    {
        if (value is not bool)
        {
            throw new InvalidOperationException("The target must be a boolean");
        }
        return !(bool)value;
    }
}